
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
Geom::Geom( GeomType T ) :	mType( T ),																										
							mFlags( CASTABLE ),
							mMaterial( 0 ),
							mTerrType(0),
							mTerrExtra( NONE ),
							mTerrExtraFilter( WATER ),							
							mEntity( NULL ),							
							mChildIndex(-1)
{}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
int Geom::GetChildIx() const
{
	return mChildIndex;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
void Geom::SetChildIx( int Ci )
{
	mChildIndex = Ci;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
Entity* Geom::GetEntity() const
{
	return mEntity;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
Geom::TerrExtra Geom::GetTerrExtraFilter() const
{
	return TerrExtra(mTerrExtraFilter);
}	

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
Geom::GeomType Geom::GetType() const	
{ 
	return (Geom::GeomType) mType; 
} 

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
MaterialIx	Geom::GetMaterial()	const			
{ 
	return mMaterial; 
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
Geom::TerrExtra	Geom::GetTerrExtra() const								
{ 
	return (TerrExtra) mTerrExtra; 
}

//////////////////////////////////////////////////////////////////////////
//Raise, test or lower the flags.
//////////////////////////////////////////////////////////////////////////
int  Geom::TestFlag( GeomFlags Flag ) const		
{	
	return mFlags & Flag;	
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
Geom::GeomFlags Geom::GetFlags() const			
{	
	return (GeomFlags) mFlags;			
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
inline Geom::TerrType Geom::GetTerrType() const
{
	return mTerrType;
}
